<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/cigar.proto

namespace Google\Genomics\V1;

/**
 * Describes the different types of CIGAR alignment operations that exist.
 * Used wherever CIGAR alignments are used.
 *
 * Protobuf enum <code>Google\Genomics\V1\CigarUnit\Operation</code>
 */
class CigarUnit_Operation
{
    /**
     * Generated from protobuf enum <code>OPERATION_UNSPECIFIED = 0;</code>
     */
    const OPERATION_UNSPECIFIED = 0;
    /**
     * An alignment match indicates that a sequence can be aligned to the
     * reference without evidence of an INDEL. Unlike the
     * `SEQUENCE_MATCH` and `SEQUENCE_MISMATCH` operators,
     * the `ALIGNMENT_MATCH` operator does not indicate whether the
     * reference and read sequences are an exact match. This operator is
     * equivalent to SAM's `M`.
     *
     * Generated from protobuf enum <code>ALIGNMENT_MATCH = 1;</code>
     */
    const ALIGNMENT_MATCH = 1;
    /**
     * The insert operator indicates that the read contains evidence of bases
     * being inserted into the reference. This operator is equivalent to SAM's
     * `I`.
     *
     * Generated from protobuf enum <code>INSERT = 2;</code>
     */
    const INSERT = 2;
    /**
     * The delete operator indicates that the read contains evidence of bases
     * being deleted from the reference. This operator is equivalent to SAM's
     * `D`.
     *
     * Generated from protobuf enum <code>DELETE = 3;</code>
     */
    const DELETE = 3;
    /**
     * The skip operator indicates that this read skips a long segment of the
     * reference, but the bases have not been deleted. This operator is commonly
     * used when working with RNA-seq data, where reads may skip long segments
     * of the reference between exons. This operator is equivalent to SAM's
     * `N`.
     *
     * Generated from protobuf enum <code>SKIP = 4;</code>
     */
    const SKIP = 4;
    /**
     * The soft clip operator indicates that bases at the start/end of a read
     * have not been considered during alignment. This may occur if the majority
     * of a read maps, except for low quality bases at the start/end of a read.
     * This operator is equivalent to SAM's `S`. Bases that are soft
     * clipped will still be stored in the read.
     *
     * Generated from protobuf enum <code>CLIP_SOFT = 5;</code>
     */
    const CLIP_SOFT = 5;
    /**
     * The hard clip operator indicates that bases at the start/end of a read
     * have been omitted from this alignment. This may occur if this linear
     * alignment is part of a chimeric alignment, or if the read has been
     * trimmed (for example, during error correction or to trim poly-A tails for
     * RNA-seq). This operator is equivalent to SAM's `H`.
     *
     * Generated from protobuf enum <code>CLIP_HARD = 6;</code>
     */
    const CLIP_HARD = 6;
    /**
     * The pad operator indicates that there is padding in an alignment. This
     * operator is equivalent to SAM's `P`.
     *
     * Generated from protobuf enum <code>PAD = 7;</code>
     */
    const PAD = 7;
    /**
     * This operator indicates that this portion of the aligned sequence exactly
     * matches the reference. This operator is equivalent to SAM's `=`.
     *
     * Generated from protobuf enum <code>SEQUENCE_MATCH = 8;</code>
     */
    const SEQUENCE_MATCH = 8;
    /**
     * This operator indicates that this portion of the aligned sequence is an
     * alignment match to the reference, but a sequence mismatch. This can
     * indicate a SNP or a read error. This operator is equivalent to SAM's
     * `X`.
     *
     * Generated from protobuf enum <code>SEQUENCE_MISMATCH = 9;</code>
     */
    const SEQUENCE_MISMATCH = 9;
}

