@extends('layouts.site')

@section('title')
<title>Políticas para o Comprador - {{env('APP_NAME')}} </title>
@endsection

@section('content')


    <main id="main" class="site-main">
        <div class="page-title page-title--small align-left" style="background-image: url({{asset('site/images/bg/bg-checkout.png')}});">
            <div class="container">
                <div class="page-title__content">
                    <h1 class="page-title__name">Políticas para o Comprador</h1>
                </div>
            </div>
        </div><!-- .page-title -->
        <section class="text-left">
            <div class="frequently-asked">
                <div class="container">
                    <div class="title">
                        <h2>Políticas para o Comprador</h2>
                    </div>
                    <ol class="ms-3 me-3">
                        <li>
                            <div class="row">
                                <div class="asked-item-new">
                                    <p>Em caso de arrependimento da compra, o reembolso do valor do
                                        ingresso estará garantido. A solicitação seja feita ao Organizador, no
                                        prazo de até 7 (sete) dias, a contar da data da compra. O pedido de
                                        devolução deverá ser realizado, preferencialmente, no prazo de 48
                                        (quarenta e oito) horas antes do horário de início do evento.</p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row">
                                <div class="asked-item-new">
                                    <p>A troca de titularidade pode ser feita apenas pelo comprador titular
                                        até 7 dias úteis antes da realização do evento.</p>
                                </div>
                            </div>
                        </li>
                        <li><div class="row">
                                <div class="asked-item-new">
                                    <p>A troca de titularidade deve ser solicitada diretamente aos
                                        organizadores do evento.</p>
                                </div></li>
                        <li>
                            <div class="row">
                                <div class="asked-item-new">
                                    <p>
                                        O consumidor deve inserir dados corretos, completos e atualizados
                                        na aquisição (onerosa ou gratuita) dos ingressos.. Caso contrário, a
                                        aquisição poderá ser invalidada e o Consumidor, caso queira, terá
                                        que fazer uma nova aquisição, estando sujeito às condições e
                                        disponibilidade de ingressos, inscrições ou contribuições nesse
                                        segundo momento.
                                    </p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row">
                                <div class="asked-item-new">
                                    <p>O consumidor deve arcar com o valor total e integral do boleto e
                                        pagá-lo até a data do seu vencimento, caso o Consumidor tenha
                                        optado por esse método de pagamento. Após a data limite de
                                        pagamento, o boleto deixa de ser válido para a compra e o ingresso
                                        não estará mais reservado para o consumidor.
                                    </p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row">
                                <div class="asked-item-new">
                                    <p>O consumidor deve apresentar, sempre que requerido, na portaria
                                        do evento, um documento de identidade com a foto do titular do
                                        cartão e/ou o cartão utilizado na compra, caso tenha adquirido
                                        ingressos via cartão de crédito, sob pena de ter o direito de acesso ao
                                        evento negado, sem que tal fato gere direito a indenização de
                                        qualquer espécie.
                                    </p>
                                </div>
                            </div>
                        </li>

                    </ol>

                </div>
            </div><!-- .frequently-asked -->
        </section>

        </div><!-- .site-content -->
    </main><!-- .site-main -->


@endsection

@section('script')

@endsection

