@extends('layouts.site')

@section('title')
    <title>Redefinir senha - {{env('APP_NAME')}} </title>
@endsection

@section('content')

    <main id="main" class="site-main">
        <div class="page-title page-title--small align-left" style="background-image: url('{{asset('site/images/bg/bg-about.png')}}');">
            <div class="container">
                <div class="page-title__content">
                    <h1 class="page-title__name">Redefinir senha</h1>
                </div>
            </div>
        </div><!-- .page-title -->
        <div class="site-content">
            <div class="checkout-area">
                <div class="container">

                    @if (isset($errors) && count($errors) > 0)
                        <div class="alert alert-danger" style="padding: 10px;">
                            <strong>Erros encontrados!</strong>
                            <ul style="margin-left: 30px;">
                                @foreach($errors->all() as $error)
                                    <li>{{$error}}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif


                    @if (session('success'))

                            <div class="alert alert-success" style="background-color: #d1e7dd; border-color: #badbcc; color: #0f5132; padding: 10px;">
                            {{ session('success') }}
                        </div>

                    @endif
                    @if (session('erro'))

                        <div class="alert alert-danger" style="padding: 20px;">
                            {{ session('erro') }}
                        </div>

                    @endif

                    <div class="row">

                        <div class="col-md-8 order-md-1">
                            <h4 class="mb-3">💳 Redefinir senha:</h4>
                            <form class="form-horizontal" method="POST" action="{{ route('reset.password.post') }}">
                                {{ csrf_field() }}
                                <input type="hidden" name="token" value="{{ $token }}">
                                <div class="row">


                                    <div class="col-md-12 mb-3">
                                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                            <label for="email">Email <span class="text-muted"></span></label>

                                            <div class="col-md-12">
                                                <input id="email" type="email" class="form-control styleform styleform" placeholder="voce@seuemail.com.br"  name="email" value="{{ old('email') }}" required>

                                                @if ($errors->has('email'))
                                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                                @endif
                                            </div>
                                        </div>

                                    </div>


                                    <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                                        <label for="password" class="col-md-4 control-label">Nova senha</label>

                                        <div class="col-md-12">
                                            <input id="password" type="password" class="form-control styleform styleform" name="password" required>

                                            @if ($errors->has('password'))
                                                <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                        <label for="password-confirm" class="col-md-4 control-label">Confirmar nova senha</label>
                                        <div class="col-md-12">
                                            <input id="password-confirm" type="password" class="form-control styleform styleform" name="password_confirmation" required>

                                            @if ($errors->has('password_confirmation'))
                                                <span class="help-block">
                                        <strong>{{ $errors->first('password_confirmation') }}</strong>
                                    </span>
                                            @endif
                                        </div>
                                    </div>



                                </div>



                                <hr class="mb-4">
                                <button class="btn btn-success btn-lg btn-block" type="submit" style="border: none">Redefinir senha</button>
                            </form>
                        </div>
                    </div>


                </div>
            </div><!-- .checkout-area -->
        </div><!-- .site-content -->
    </main><!-- .site-main -->

@endsection

@section('script')

@endsection

