<?php

namespace App\Http\Controllers;

use App\Models\Eventos;
use App\Models\Funcoes;
use App\Models\Ingressos;
use App\Models\LogWebhook;
use App\Models\Titulares;
use App\Models\User;
use App\Models\Vendas;
use http\Env\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class WebhookController extends Controller
{
    public function index(Request $request)
    {

        if (!$request->all()) {
            echo "Erro ao enviar Notificacão";
            http_response_code(403);
            exit();
        }

        $json = file_get_contents('php://input');

// Converts it into a PHP object
        $datos = json_decode($json);


        if (isset($datos->type)) {

            if ($datos->type != 'payment') {
                echo "Erro ao enviar Notificacão";
                http_response_code(403);
                exit();
            }
        } else {
            echo "Erro ao enviar Notificacão";
            http_response_code(403);
            exit();

        }
        if (!isset($datos->data->id)) {
            echo "Erro ao enviar Notificacão";
            http_response_code(403);
            exit();

        }

        $idfatura = $datos->data->id;
//$idfatura = $_POST["id"];

        LogWebhook::create([
            'webhook' => serialize($datos),
            'tipo' => $datos->action,
            'idfatura' => $idfatura,
        ]);


        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.mercadopago.com/v1/payments/' . $idfatura,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'accept: application/json',
                'content-type: application/json',
                'Authorization: Bearer APP_USR-11269492600129-060100-bf16d53a0b0517eac6bf268b7047315a-577106088'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $dados = json_decode($response);

        $status = $dados->status;

//$idfatura = '01A01D9F0735488098CFF892C39D4B70';
//$status = 'paid';

        LogWebhook::create([
            'webhook' => serialize($dados),
            'tipo' => $dados->status,
            'idfatura' => $idfatura,
        ]);


        if ($status == 'approved') {


            $venda = Vendas::where('idfatura', $idfatura)->first();

            if ($venda->status != 'confirmado') {

                                                                        $status = 'confirmado';

                                                                        //atualizando tabela vendas
                                                                        Vendas::where('idfatura', $idfatura)->update([
                                                                            'status' => $status
                                                                        ]);


                                                                        Titulares::where('idfatura', $idfatura)
                                                                            ->update([
                                                                                'status' => $status
                                                                            ]);


                                                                        $texto = 'Sua compra foi confirmada com sucesso. Muito obrigado <b>' . $venda->cliente->nome . '</b>.';
                                                                        $texto .= '<br> <br>Para visualizar seu ingresso, acesse a área do cliente no botão abaixo. E lembre-se: Leve um documento com foto no dia do evento 😜.';
                                                                        $title = 'Ingresso Confirmado';
                                                                        $url = route('site.login');
                                                                        $textobotao = 'Acessar Ingresso';

                                                                        (new  \App\Models\Funcoes())->enviarEmail($venda->cliente->email, $title, $texto, $url, $textobotao);

                                                                        $evento = Eventos::find($venda->idevento);
                                                                        $texto = 'O Cliente ' . $venda->cliente->nome . ' fez uma compra de ' . $venda->quantidade . ' novo(s) ingresso(s) do evento ' . $evento->nome . ' no valor de R$:' . $venda->valortotal;
                                                                        $title = 'Novo ingresso vendido';
                                                                        (new  \App\Models\Funcoes())->enviarEmail('guimenegussi@gmail.com', $title, $texto);
                                                                        if (isset($evento->organizador->email)) {
                                                                            (new  \App\Models\Funcoes())->enviarEmail($evento->organizador->email, $title, $texto);
                                                                        }
                                                    }

        } else {

            if ($status == 'cancelled') {
                $status = 'cancelada';
            } else if ($status == 'expired') {
                $status = 'expirou';
            } else if ($status == 'charged_back') {
                $status = 'extornado';
            } else if ($status == 'pending') {
                $status = 'pendente';
            } else if ($status == 'refunded') {
                $status = 'recusada';
            } else if ($status == 'rejected') {
                $status = 'rejeitada';
            }

            //atualizando tabela vendas
            $vendas = Vendas::where('idfatura', $idfatura)->update([
                'status' => $status
            ]);


            $titulares = Titulares::where('idfatura', $idfatura)
                ->update([
                    'status' => $status
                ]);
        }

        echo 'Status da fatura: ' . $idfatura . ' alterada!';

    }

}
