<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Category;
use App\Models\Noticia;
use Carbon\Carbon;
use Illuminate\Http\Request;


class NoticiasController extends Controller
{
    public function getnoticias(Request $request) {

        $noticias = Noticia::where('status',1)
            ->where('noticia_edicao','>=', 1)
            ->where('destaque', 'Sim')
            ->where('datapublicacao','<=', Carbon::now())
            ->limit(4)
            ->where(function ($query) use ($request) {
                if($request->categoria){
                    $query->where('category_id',$request->categoria);
                }

            })
            ->orderby('id','desc')->get();

            $categorias = Category::all();

        $noticias->transform(function ($value)  {


            $value->categoria = Category::find($value->category_id)->name;

            $admin = Admin::find($value->user_account_id);


            $value->nomeautor = $admin->name;
            $value->texto = mb_strimwidth(strip_tags($value->conteudo), 0, 100, "");
            $value->avatar = $admin->avatar;
            $value->data = $value->created_at->format('d/m/Y H:i');

            return $value;
        });

        return response()->json(compact('noticias','categorias'));
    }
    public function getnoticiastotal(Request $request) {

        $noticias = Noticia::where('status',1)
            ->where('noticia_edicao','>=', 1)
            ->where('datapublicacao','<=', Carbon::now())
            ->where(function ($query) use ($request) {
                if($request->pesquisa){
                    $query->where('created_at','LIKE','%'. $request->pesquisa .'%')
                        ->orwhere('conteudo','LIKE','%'. $request->pesquisa .'%')
                        ->orwhere('titulo','LIKE','%'. $request->pesquisa .'%');
                }

            })
            ->where(function ($query) use ($request) {
                if($request->categoria){
                    $query->where('category_id',$request->categoria);
                }

            })->orderby('id','desc')->get();

    $categorias = Category::all();

        $noticias->transform(function ($value)  {


            $value->categoria = Category::find($value->category_id)->name;

            $admin = Admin::find($value->user_account_id);


            $value->nomeautor = $admin->name;
            $value->avatar = $admin->avatar;
            $value->texto = mb_strimwidth(strip_tags($value->conteudo), 0, 100, "");
            $value->data = $value->created_at->format('d/m/Y H:i');

            return $value;
        });

        return response()->json(compact('noticias','categorias'));
    }





}
