<!DOCTYPE html>

<html
        lang="<?php echo e(app()->getLocale()); ?>"
        class="light-style customizer-hide"
        dir="ltr"
        data-theme="theme-default"
        data-assets-path="igreja_assets/assets/"
        data-template="vertical-menu-template-free"
>

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title> Login Gerenciamento - <?php echo e(env('APP_NAME')); ?> </title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('ADM/assets/img/favicon/favicon.ico')); ?>" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="<?php echo e(asset('ADM/assets/vendor/fonts/boxicons.css')); ?>" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('ADM/assets/vendor/css/core.css')); ?>" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?php echo e(asset('ADM/assets/vendor/css/theme-default.css')); ?>" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?php echo e(asset('ADM/assets/css/demo.css')); ?>" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('ADM/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="<?php echo e(asset('ADM/assets/vendor/css/pages/page-auth.css')); ?>" />
    <!-- Helpers -->
    <script src="<?php echo e(asset('ADM/assets/vendor/js/helpers.js')); ?>"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?php echo e(asset('ADM/assets/js/config.js')); ?>"></script>
</head>

<body style="background-image: url(<?php echo e(asset('images/header.jpg')); ?>);    background-size: cover; background-position: center; background-repeat: no-repeat;">
<!-- Content -->

<div class="container-xxl" >
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner">
            <!-- Register -->
            <div class="card">
                <div class="card-body">

                    <!-- Logo -->
                    <div class="" style="text-align: center; width: 100%; margin-bottom: 20px;">
                        <a href="#" class="">

                                <span class="" style="text-align: center;">
                                    <img src="<?php echo e(asset('images/logo.svg')); ?>" alt="logo" width="60%">
                                </span>
                        </a>
                    </div>

                    <!-- /Logo -->



                    <?php if(isset($errors) && count($errors) > 0): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>


                    <?php if(session('success')): ?>

                        <div class="alert alert-success" style="background-color: #d1e7dd; border-color: #badbcc; color: #0f5132; padding: 10px;">

                        <?php echo e(session('success')); ?>

                        </div>

                    <?php endif; ?>
                    <?php if(session('erro')): ?>

                        <div class="alert alert-danger">
                            <?php echo e(session('erro')); ?>

                        </div>

                    <?php endif; ?>

                    <form id="formAuthentication" class="mb-3" action="<?php echo e(route('admin.logar')); ?>" method="POST">
                        <?php echo e(csrf_field()); ?>

                        <div class="mb-3">
                            <label for="email" class="form-label">Username</label>
                            <input type="text" class="form-control" required id="email" value="<?php echo e(old('email')); ?>" name="email" placeholder="Digite seu Username" autofocus />
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <div class="d-flex justify-content-between">
                                <label class="form-label" for="password">Senha</label>

                            </div>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" required class="form-control" name="password" placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" aria-describedby="password" />
                                <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            </div>
                        </div>
                        <div class="col d-flex justify-content-left mb-3">
                            <!-- Checkbox -->
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="lembrar" id="form2Example31" />
                                <label class="form-check-label" for="form2Example31"> Lembrar</label>
                            </div>
                        </div>
                        <div class="mb-3">
                            <button class="btn btn-primary d-grid w-100" type="submit">Entrar</button>
                        </div>
                    </form>

                    <ul class="navbar-nav justify-content-left ms-auto">
                        <!-- Place this tag where you want the button to render. -->

                        <!-- traducao -->
                        <!--/ traducao -->
                    </ul>
                </div>
            </div>
            <!-- /Register -->
        </div>
    </div>
</div>

<!-- / Content -->


<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="<?php echo e(asset('ADM/assets/vendor/libs/jquery/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('ADM/assets/vendor/libs/popper/popper.js')); ?>"></script>
<script src="<?php echo e(asset('ADM/assets/vendor/js/bootstrap.js')); ?>"></script>
<script src="<?php echo e(asset('ADM/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>

<script src="<?php echo e(asset('ADM/assets/vendor/js/menu.js')); ?>"></script>
<!-- endbuild -->

<!-- Vendors JS -->

<!-- Main JS -->
<script src="<?php echo e(asset('ADM/assets/js/main.js')); ?>"></script>

<!-- Page JS -->


</body>

</html><?php /**PATH C:\xampp2\htdocs\digital\teste\fronter\resources\views/admin/login.blade.php ENDPATH**/ ?>