@extends('layouts.site')

@section('title')
    <title>{{$projeto->titulo}} {{env('APP_NAME')}}</title>
@endsection

@section('content')

    <div id="wrapper">
        <div class="content-holder elem scale-bg2 transition3">
            <div class="content">
                <!-- background animation  -->
                <div class="bg-animate"><img src="images/body-bg.png" class="respimg" alt=""></div>
                <!-- wrapper inner -->
                <div class="wrapper-inner">
                    <section class="no-padding no-border">
                        <!-- page title -->
                        <div class="container">
                            <div class="page-title no-border">
                                <h2>{{$projeto->titulo}}</h2>
                            </div>
                        </div>
                    </section>
                    <div class="clearfix"></div>
                    <div class="container">
                        <section>
                            <div class="gallery-items three-coulms grid-small-pad popup-gallery">

                                @foreach($galeria as $g)
                                    <!-- 1 -->
                                    <div class="gallery-item houses">
                                        <div class="grid-item-holder">
                                            <div class="box-item">
                                                <a href="{{asset($g->url)}}" title="{{$projeto->titulo}}">
                                                    <span class="overlay"></span>
                                                    <img src="{{asset($g->url)}}" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- 2 -->
                                @endforeach
                            </div>
                            <!-- end gallery items -->
                            <div class="row">
                                <div class="col-md-10">
                                    <div class="project-details">

                                        {!! $projeto->descricao !!}
                                        <ul class="descr">
                                            <li><span>Data :</span> {{$projeto->dataExeculcao->format('d/m/Y')}} </li>
                                            <li><span>Cliente :</span> {{$projeto->nomeCliente}} </li>
                                            <li><span>Status :</span> {{$projeto->statusObra}} </li>
                                            <li><span>Localização : </span> <a href="{{$projeto->localizacao}}"
                                                                               target="_blank"> Acessar Mapa </a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </section>
                        <!-- about text end -->
                        <div class="content-nav">
                            <ul>
                                @php
                                    $projetoanterior = \App\Models\Obras::where('status','Ativo')->where('id',$projeto->id - 1)->first();
                                    $projetoposterior = \App\Models\Obras::where('status','Ativo')->where('id',$projeto->id + 1)->first();
                                @endphp

                                @if(isset($projetoanterior->id))
                                    <li>
                                        <a href="{{route('site.projeto',[(NEW \App\Models\Funcoes())->getSlug($projetoanterior->titulo),$projetoanterior->id])}}"
                                           class="ajax"><i class="fa fa-long-arrow-left"></i></a></li>
                                @endif
                                @if(isset($projetoanterior->id) and isset($projetoanterior->id))
                                    <li><span>/</span></li>
                                @endif
                                @if(isset($projetoposterior->id))
                                    <li>
                                        <a href="{{route('site.projeto',[(NEW \App\Models\Funcoes())->getSlug($projetoposterior->titulo),$projetoposterior->id])}}"
                                           class="ajax"><i class="fa fa-long-arrow-right"></i></a></li>
                                @endif
                            </ul>
                            <div class="p-all">
                                <a href="{{route('site.portifolio')}}" class="ajax"><i class="fa fa-th-large"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- wrapper inner end   -->
                <!-- parallax column   -->
                <div class="img-wrap">
                    <div class="bg" style="background-image: url({{asset('ADM/'.$projeto->imagem_destaque)}})"
                         data-top-bottom="transform: translateY(300px);"
                         data-bottom-top="transform: translateY(-300px);"></div>
                </div>
                <!-- parallax column end   -->
                <!--to top    -->
                <div class="to-top">
                    <i class="fa fa-long-arrow-up"></i>
                </div>
                <!-- to top  end -->
                <!--=============== footer ===============-->
                <div class="height-emulator"></div>

                <!-- footer end    -->
                @include ('site.repeat.footer')
                <!-- footer end    -->
            </div>
            <!-- content  end  -->
        </div>
        <!-- content-holder  end  -->
    </div>
@endsection

@section('script')

@endsection

