@extends('layouts.site')

@section('title')
<title> Crie sua conta - {{env('APP_NAME')}} </title>
@endsection

@section('content')


    <main id="main" class="site-main">
        <div class="page-title page-title--small align-left" style="background-image: url('{{asset('site/images/bg/bg-about.png')}}');">
            <div class="container">
                <div class="page-title__content">
                    <h1 class="page-title__name">Crie sua conta</h1>
                </div>
            </div>
        </div><!-- .page-title -->
        <div class="site-content">
            <div class="checkout-area">
                <div class="container">



                    <div class="row">

                        <div class="col-md-8 order-md-1">
                            <h4 class="mb-3">💳 Antes de prosseguir para o pagamento, precisamos criar sua conta:</h4>
                            <p>Já possui conta? <a href="{{route('site.login')}}"><u>Clique aqui</u></a> e faça seu login</p><br/>
                            <form method="post" id="cadastro">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="nome">Nome Completo</label>
                                        <input type="text" class="form-control styleform" id="nome" name="nome" placeholder=""  required>



                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="email">Email <span class="text-muted"></span></label>
                                        <input type="email" class="form-control styleform styleform" id="email" name="email" placeholder="voce@seuemail.com.br" required>

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="whatsapp">Seu WhatsApp</label>
                                        <input type="tel" class="form-control styleform" id="whatsapp" name="whatsapp" placeholder=""  required>

                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="email">CPF <span class="text-muted"></span></label>
                                        <input type="text" class="form-control styleform" id="cpf" name="cpf" placeholder="" required>

                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="whatsapp">Sua Senha</label>
                                        <input type="password" class="form-control styleform" id="senha" name="senha" placeholder=""  required>

                                    </div>

                                </div>






                                <hr class="mb-4">
                                <button class="btn btn-success btn-lg btn-block" type="submit" style="border: none">CONCLUIR</button>
                            </form>
                        </div>
                    </div>


                </div>
            </div><!-- .checkout-area -->
        </div><!-- .site-content -->
    </main><!-- .site-main -->


@endsection

@section('script')
    <!-- Bootstrap core JavaScript
================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

    <script src="{{asset('site/dist/js/bootstrap.min.js')}}"></script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery.maskedinput/1.4.1/jquery.maskedinput.min.js"></script>

    <script>
        var url_checkout = '{!! Session()->get('urlcadastro') !!}';
        jQuery("#cpf").mask("999.999.999-99");
        jQuery("#whatsapp")
            .mask("(99) 9999-9999?9")
            .focusout(function (event) {
                var target, phone, element;
                target = (event.currentTarget) ? event.currentTarget : event.srcElement;
                phone = target.value.replace(/\D/g, '');
                element = $(target);
                element.unmask();
                if(phone.length > 10) {
                    element.mask("(99) 99999-999?9");
                } else {
                    element.mask("(99) 9999-9999?9");
                }
            });

        function cria_cadastro(dados){
            jQuery.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            //console.log(dados);
            jQuery.ajax({
                type: "POST",
                url: "{{route('site.cadastrar')}}",
                data: dados,
                beforeSend: function() {
                    Swal.fire({
                        title: 'Criando sua conta..',
                        text: 'Obrigado por escolher o Ingresso na Mão',
                        showConfirmButton: false,
                        imageUrl: 'https://pedefacil.sodexobeneficios.com.br/PPW/img/tela-espera.gif',
                        imageWidth: 80,
                        imageHeight: 80,
                        imageAlt: 'aguarde'
                    })
                },
                success: function(data)
                {
                    data = JSON.stringify(data);
                    data = JSON.parse(data);

                    if(data.retorno == 'sucesso'){
                        window.location.href = url_checkout;
                    }else{
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro ao cadastrar',
                            text: data.retorno
                        })
                    }


                },

            });
        }

        jQuery(document).ready(function(){
            jQuery('#cadastro').submit(function(){
                //alert("form de cadastro enviado");
                var dados = jQuery( this ).serialize();
                //alert(dados);
                cria_cadastro(dados);
                return false;
            });
        });
    </script>
@endsection

