@extends('layouts.admin')

@section('content')




    <!--begin::Main-->
    <div class="app-main flex-column flex-row-fluid " id="kt_app_main">

        <!--conteudo-->

        <div class="d-flex flex-column flex-column-fluid">
            <!--begin::Toolbar-->
            <div id="kt_app_toolbar" class="app-toolbar  py-3 py-lg-6 "
            >
                <!--begin::Toolbar container-->
                <div id="kt_app_toolbar_container" class="app-container  container-xxl d-flex flex-stack ">
                    <!--begin::Page title-->
                    <div  class="page-title d-flex flex-column justify-content-center flex-wrap me-3 ">
                        <!--begin::Title-->
                        <!--end::Title-->
                        <!--begin::Breadcrumb-->
                        <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                            <!--begin::Item-->
                            <li class="breadcrumb-item text-muted">
                                <a href="{{route('admin.dashboard')}}" class="text-muted text-hover-primary">
                                    Prefeitura de congonhas                            </a>
                            </li>
                            <!--end::Item-->
                            <!--begin::Item-->
                            <li class="breadcrumb-item">
                                <span class="bullet bg-gray-500 w-5px h-2px"></span>
                            </li>
                            <!--end::Item-->
                            <!--begin::Item-->
                            <li class="breadcrumb-item text-muted">
                                noticias
                            </li>
                            <!--end::Item-->
                        </ul>
                        <!--end::Breadcrumb-->
                    </div>
                    <!--end::Page title-->

                    <div class="d-flex align-items-center gap-2 gap-lg-3">
                        <!--begin::Filter menu-->
                        <div class="m-0">
                            <!--begin::Menu toggle-->
                            <a href="#" class="btn btn-sm btn-flex btn-secondary fw-bold" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                <i class="ki-duotone ki-filter fs-6 text-muted me-1"><span class="path1"></span><span class="path2"></span></i>
                                Buscar
                            </a>
                            <!--end::Menu toggle-->



                            <!--begin::Menu 1-->
                            <div class="menu menu-sub menu-sub-dropdown w-250px w-md-300px" data-kt-menu="true" id="kt_menu_65715579bd0d1">
                                <form action="{{route('noticias.buscar')}}" method="POST" >
                                    @csrf
                                    <!--begin::Header-->
                                    <div class="px-7 py-5">
                                        <div class="fs-5 text-gray-900 fw-bold">Filtrar</div>
                                    </div>
                                    <!--end::Header-->

                                    <!--begin::Menu separator-->
                                    <div class="separator border-gray-200"></div>
                                    <!--end::Menu separator-->


                                    <!--begin::Form-->
                                    <div class="px-7 py-5">
                                        <!--begin::Input group-->

                                        <!--end::Input group-->

                                        <!--begin::Input group-->
                                        <div class="mb-10">
                                            <!--begin::Label-->
                                            <label class="form-label fw-semibold">faça uma busca:</label>
                                            <!--end::Label-->

                                            <!--begin::Options-->
                                            <div class="d-flex">
                                                <!--begin::Options-->
                                                <label class="form-check form-check-sm form-check-custom form-check-solid me-5">
                                                    <input type="text" name="buscar" value="@if(isset($request->buscar)){{$request->buscar}}@endif"  class="form-control" style="width: 100%;">

                                                </label>
                                                <!--end::Options-->


                                                <!--end::Options-->
                                            </div>
                                            <!--end::Options-->
                                        </div>
                                        <!--end::Input group-->



                                        <!--begin::Actions-->
                                        <div class="d-flex justify-content-end">

                                            <button type="submit" class="btn btn-sm btn-primary" data-kt-menu-dismiss="true">Buscar</button>
                                        </div>
                                        <!--end::Actions-->
                                    </div>
                                    <!--end::Form-->
                                </form>
                            </div>



                            <!--end::Menu 1-->        </div>
                        <!--end::Filter menu-->


                        <!--begin::Secondary button-->
                        <!--end::Secondary button-->

                        <!--begin::Primary button-->
                        <a href="{{ route('noticias.create') }}" class="btn btn-sm fw-bold btn-primary" >
                            Criar nova        </a>
                        <!--end::Primary button-->
                    </div>

                </div>
                <!--end::Toolbar container-->
            </div>
            <!--end::Toolbar-->
            <!--begin::Content-->
            <div id="kt_app_content" class="app-content  flex-column-fluid " >
                <!--begin::Content container-->
                <div id="kt_app_content_container" class="app-container  container-xxl ">

                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box">
                                <h4 class="page-title float-left">Lista de noticias</h4>

                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->



                    <!-- recent orders  -->
                    <!-- ============================================================== -->
                    <div class="col-xl-12 col-lg-12 col-md-6 col-sm-12 col-12">

                        <div class="table-responsive">
                            <table class="table table-rounded table-striped border gy-7 gs-7">
                                <thead>
                                <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                    <th>Titulo</th>
                                    <th>Categoria</th>
                                    <th>Data</th>
                                    <th>Status</th>
                                    <th>Funções</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($categories as $category)

                                    <tr>

                                        <td>
                                            <div class="m-r-10">{{ $category->titulo}}</div>
                                        </td>
                                        <td>{{\App\Models\Category::find($category->category_id)->name}} </td>
                                        <td>{{ date('d/m/Y' ,strtotime($category->created_at))}} </td>
                                        <td>
                                            @if($category->status == 1)
                                                <a href="{{route('noticias.status',[$category->id,'0'])}}" title="Desativar" data-confirm2='Tem certeza de que deseja Desativar o item selecionado?'  class="btn btn-success"><i class="fa fa-toggle-on" aria-hidden="true"></i></a>
                                            @else
                                                <a href="{{route('noticias.status',[$category->id,'1'])}}" title="ativar" data-confirm3='Tem certeza de que deseja Desativar o item selecionado?'  class="btn btn-danger"><i class="fa fa-toggle-off" aria-hidden="true"></i></a>

                                            @endif
                                        </td>


                                        <td>

                                            <a href="{{route('noticias.edit',[$category->id])}}" title="Editar" class="btn btn-primary"> <i class="fa fa-edit" aria-hidden="true"></i></a>
                                            <a href="javascript:void(0)" onclick="deletar('{{route('noticias.delete',[$category->id])}}')" title="Deletar" data-confirm='Tem certeza de que deseja Desativar o item selecionado?'  class="btn btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></a>


                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                            </table>
                            {!! $categories->links('pagination.default') !!}
                        </div>


                    </div>
                    <!-- ============================================================== -->
                    <!-- end recent orders  -->


                </div>
                <!--end::Content container-->
            </div>
            <!--end::Content-->
        </div>




        <!--begin::Footer-->
        <div id="kt_app_footer" class="app-footer " >
            <!--begin::Footer container-->
            <div class="app-container  container-fluid d-flex flex-column flex-md-row flex-center flex-md-stack py-3 ">
                <!--begin::Copyright-->
                <div class="text-gray-900 order-2 order-md-1">
                    <span class="text-muted fw-semibold me-1">2024&copy;</span>
                    <a href="" target="_blank" class="text-gray-800 text-hover-primary">Rlv Tecnologia</a>
                </div>
                <!--end::Copyright-->
                <!--begin::Menu-->
                <ul class="menu menu-gray-600 menu-hover-primary fw-semibold order-1">
                    <li class="menu-item"><a href="" target="_blank" class="menu-link px-2">Sobre</a></li>
                    <li class="menu-item"><a href="" target="_blank" class="menu-link px-2">Suporte</a></li>
                </ul>
                <!--end::Menu-->
            </div>
            <!--end::Footer container-->
        </div>
        <!--end::Footer-->
    </div>
    <!--end:::Main-->



@endsection




@section('script')


    <script>

        function deletar(href){

            if(!$('#confirm-delete').length){
                $('body').append('<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" ' +
                    'aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog">' +
                    '<div class="modal-content"><div class="modal-header bg-danger text-white">DELETAR NOTICIA' +
                    '<button type="button" class="close" data-dismiss="modal" aria-label="Close">' +
                    '<span aria-hidden="true">&times;</span></button></div><div class="modal-body">' +
                    'Tem certeza de que deseja Deletar a noticia ?</div><div class="modal-footer">' +
                    '<button type="button" class="btn btn-primary" data-bs-dismiss="modal" aria-label="Close">Cancelar' +
                    '</button><a class="btn btn-danger text-white" id="dataComfirmOK">Deletar</a><' +
                    '/div></div></div></div>');
            }
            $('#dataComfirmOK').attr('href', href);

            var myModal = new bootstrap.Modal(document.getElementById('confirm-delete'))
            myModal.show();


            return false;
        }




        $(document).ready(function(){





            $('a[data-confirm2]').click(function(ev){
                console.log('aaaa');
                var href = $(this).attr('href');
                if(!$('#confirm-delete2').length){
                    $('body').append('<div class="modal fade" id="confirm-delete2" tabindex="-1" role="dialog" ' +
                        'aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog">' +
                        '<div class="modal-content"><div class="modal-header bg-danger text-white">DESATIVAR NOTICIA' +
                        '<button type="button" class="close" data-dismiss="modal" aria-label="Close">' +
                        '<span aria-hidden="true">&times;</span></button></div><div class="modal-body">' +
                        'Tem certeza de que deseja Desativar a noticia ?</div><div class="modal-footer">' +
                        '<button type="button" class="btn btn-primary" data-dismiss="modal">Cancelar' +
                        '</button><a class="btn btn-danger text-white" id="dataComfirmOK2">Desativar</a><' +
                        '/div></div></div></div>');
                }
                $('#dataComfirmOK2').attr('href', href);
                $('#confirm-delete2').modal({show: true});
                return false;

            });

            $('a[data-confirm3]').click(function(ev){
                console.log('aaaa');
                var href = $(this).attr('href');
                if(!$('#confirm-delete3').length){
                    $('body').append('<div class="modal fade" id="confirm-delete3" tabindex="-1" role="dialog" ' +
                        'aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog">' +
                        '<div class="modal-content"><div class="modal-header bg-success text-white">ATIVAR NOTICIA' +
                        '<button type="button" class="close" data-dismiss="modal" aria-label="Close">' +
                        '<span aria-hidden="true">&times;</span></button></div><div class="modal-body">' +
                        'Tem certeza de que deseja Desativar a noticia ?</div><div class="modal-footer">' +
                        '<button type="button" class="btn btn-primary" data-dismiss="modal">Cancelar' +
                        '</button><a class="btn btn-success text-white" id="dataComfirmOK3">Ativar</a><' +
                        '/div></div></div></div>');
                }
                $('#dataComfirmOK3').attr('href', href);
                $('#confirm-delete3').modal({show: true});
                return false;

            });

        });


    </script>
@endsection
