<?php

namespace App\Http\Controllers;

use App\Models\Categorias;
use App\Models\ConfiguracaoQuemSomos;
use App\Models\EquipeQuemSomos;
use App\Models\Eventos;
use App\Models\Funcoes;
use App\Models\Galeria;
use App\Models\GaleriaQuemSomos;
use App\Models\Ingressos;
use App\Models\Obras;
use App\Models\Trackeamento;
use App\Models\User;
use http\Env\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class SiteController extends Controller
{
    public function index() {
        $projetos = Obras::where('status','Ativo')->where('isHome',1)->limit(4)->get();
        return view('index',compact('projetos'));
    }

    public function portifolio() {
        $projetos = Obras::where('status','Ativo')->paginate();
        $categorias = Categorias::all();
        return view('site.portifolio',compact('projetos','categorias'));
    }

    public function contato() {

        return view('site.contato');
    }

    public function sobrenos() {
        $config = ConfiguracaoQuemSomos::find(1);
        $projetoscount = Obras::where('status','Ativo')->count();
        $equipe = EquipeQuemSomos::all();
        $projetos = Obras::where('status','Ativo')->paginate();
        $galeriasquemsomos = GaleriaQuemSomos::where('tipo','galeria')->get();
        return view('site.sobrenos',compact(['config','projetoscount','equipe','projetos','galeriasquemsomos']));
    }

    public function projeto($titulo, $id) {
        $projeto = Obras::where('id',$id)->where('status','Ativo')->first();

        if(!isset($projeto->id)){
            return redirect()->route('site.index');
        }

        $galeria = Galeria::where('projeto_id',$id)->get();

        return view('site.projeto',compact('projeto','galeria'));
    }





}
