<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Category;
use App\Models\Noticia;
use App\Models\Servico;
use Illuminate\Http\Request;


class ServicosController extends Controller
{
    public function getservicos(Request $request) {

        $servicos = Servico::orderby('ordem')
            ->where(function ($query) use ($request) {
                if($request->pesquisa){
                    $query->where('created_at','LIKE','%'. $request->pesquisa .'%')
                        ->orwhere('name','LIKE','%'. $request->pesquisa .'%')
                        ->orwhere('url','LIKE','%'. $request->pesquisa .'%')
                        ->orwhere('ordem','LIKE','%'. $request->pesquisa .'%')
                        ->orwhere('icon','LIKE','%'. $request->pesquisa .'%')
                        ->orwhere('subname','LIKE','%'. $request->pesquisa .'%');
                }

            })
            ->limit($request->limit ? $request->limit: 1000)
            ->get();


        $servicos->transform(function ($value)  {

            $icon = explode('-',$value->icon);
            $icone2 = isset($icon[2]) ? '-'.$icon[2]:'';
            $icone3 = isset($icon[3]) ? '-'.$icon[3]:'';

            $value->icone = $icon[1].$icone2.$icone3;

            return $value;
        });

        return response()->json(compact('servicos'));
    }



 public function getlinks(Request $request) {



        $links =[
            'ajuda'=>'asasas',
            'sobre'=>'asasas',
            'sobredesenv'=>'asasas',
            'politica'=>'asasas',
            'avalie'=>'asasas',
        ];


        return response()->json(compact('links'));
    }






}
