<?php

namespace App\Http\Controllers\Admin;

use File;
use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\ImagemNoticia;
use App\Models\Noticia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mockery\Matcher\Not;

class NoticiaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$accountId = \Auth::user();
        $categories = Noticia::where('noticia_edicao','>=', 1)->orderby('created_at', 'desc')->paginate();
        return view('app.noticia.index',compact('categories'));
    }

    public function busca(Request $request)
    {
        $accountId = \Auth::user()->account->id;
        $categories = Noticia::where('account_id',$accountId)
            ->where('noticia_edicao','>=', 1)
            ->where(function ($query) use ($request) {
                $query->where('created_at','LIKE','%'. $request->buscar .'%')
                    ->orwhere('conteudo','LIKE','%'. $request->buscar .'%')
                    ->orwhere('titulo','LIKE','%'. $request->buscar .'%')
                    ->orWhereHas('user_account', function($q) use ($request){
                        return $q->where('name', 'LIKE','%'. $request->buscar .'%');
                    });
                // ->orwhere('user_account.name','LIKE','%'. $request->buscar .'%');
            })
            ->paginate(50);
        return view('app.noticia.index',compact('categories'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      $categorys = Category::all();
      $ifnoti = Noticia::where('user_account_id',auth('admin')->user()->id)->where('noticia_edicao',0)->first();
      if($ifnoti == null){
          $noticia1 = Noticia::create([
              'noticia_edicao'=>'0',
              'user_account_id'=>auth('admin')->user()->id,
          ]);
      } else{
          $noticia1 = $ifnoti;
      }

      return view('app.noticia.create',compact('categorys','noticia1'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        if (  $data['category_id'] == 0){
            return back()->with('erro','Erro: É obrigatorio selecionar uma categoria ');
        }
            $this->validate(request(), [
                'img' => 'required',
            ], [
                'required' => 'O campo Imagem destacada é obrigatório',
            ]);
        function tirarAcentos($string){
            return preg_replace(array("/(á|à|ã|â|ä)/","/(Á|À|Ã|Â|Ä)/","/(é|è|ê|ë)/","/(É|È|Ê|Ë)/","/(í|ì|î|ï)/","/(Í|Ì|Î|Ï)/","/(ó|ò|õ|ô|ö)/","/(Ó|Ò|Õ|Ô|Ö)/","/(ú|ù|û|ü)/","/(Ú|Ù|Û|Ü)/","/(ñ)/","/(Ñ)/"),explode(" ","a A e E i I o O u U n N"), str_replace(" ", "-", $string));
        }
        $str = strtolower(tirarAcentos($data['titulo']));
        $str = substr($str, 0, 50);
        if($request->img)
        {
            $imagem = $request->img;
            $extensao = $imagem->getClientOriginalExtension();
            if(
                $extensao != 'jpg'
                && $extensao != 'png'
                && $extensao != 'svg'
                && $extensao != 'jpeg'
                && $extensao != 'JPEG'
                && $extensao != 'JPG'
                && $extensao != 'PNG'
            )
            {
                return back()->with('erro','Erro: Este arquivo não é uma imagem valida (jpg, png, svg, jpeg )');
            }
        }
        $rand = rand(1,100000);
        $time = time();

        if($request->img)
        {
            $strCaminho = public_path().'/portais/noticias/';
            if(!file_exists($strCaminho)) { // Cria pasta para o projeto, caso não já exista uma
                $objProjetoDiretorio = File::makeDirectory($strCaminho,0777,true);
            }
            $request->img->move($strCaminho,$time.$rand.'.'.$extensao);
            $data['img'] ='/portais/noticias/'.$time.$rand.'.'.$extensao;
        }
        $conta = Noticia::where('url',$str )->count() ;
        if( $conta >= 1) { $data['url'] = $str.rand(1,1000) ;  } else {  $data['url'] = $str ;  }
          $data['noticia_edicao'] = 1;
        $id = Noticia::find($request->noticia_id)->update($data);
        $this->enviarimagem($request,$request->noticia_id);
        if(isset($request->criar)){
            return redirect()->route('noticias.index');
        }else{
            return redirect()->route('noticias.edit', [$request->noticia_id]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function show(Page $category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = Noticia::find($id);
        $noticia1 = $category;
        $categorys = Category::all();

        return view('app.noticia.edit',compact('category','categorys','noticia1'));
    }


    public function status($id,$status)
    {
        Noticia::find($id)->update([
            'status'=>$status
        ]);
        return redirect()->route('noticias.index');
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        if (  $data['category_id'] == 0){
            return back()->with('erro','Erro: É obrigatorio selecionar uma categoria ');
        }
        function tirarAcentos($string){
            return preg_replace(array("/(á|à|ã|â|ä)/","/(Á|À|Ã|Â|Ä)/","/(é|è|ê|ë)/","/(É|È|Ê|Ë)/","/(í|ì|î|ï)/","/(Í|Ì|Î|Ï)/","/(ó|ò|õ|ô|ö)/","/(Ó|Ò|Õ|Ô|Ö)/","/(ú|ù|û|ü)/","/(Ú|Ù|Û|Ü)/","/(ñ)/","/(Ñ)/"),explode(" ","a A e E i I o O u U n N"), str_replace(" ", "-", $string));
        }
        if($request->img)
        {
            $imagem = $request->img;
            $extensao = $imagem->getClientOriginalExtension();
            if(
                $extensao != 'jpg'
                && $extensao != 'png'
                && $extensao != 'svg'
                && $extensao != 'jpeg'
                && $extensao != 'JPEG'
                && $extensao != 'JPG'
                && $extensao != 'PNG'
            )
            {
                return back()->with('erro','Erro: Este arquivo não é uma imagem valida (jpg, png, svg, jpeg)');
            }
        }
$rand = rand(1,100000);
$time = time();
        if($request->img)
        {
            $strCaminho = public_path().'/portais/noticias/';

            if(!file_exists($strCaminho)) { // Cria pasta para o projeto, caso não já exista uma
                $objProjetoDiretorio = File::makeDirectory($strCaminho,0777,true);
            }
            $request->img->move($strCaminho,$time.$rand.'.'.$extensao);
            $data['img'] ='/portais/noticias/'.$time.$rand.'.'.$extensao;

        }
        $data['noticia_edicao'] = 1;
        $category = Noticia::find($id);
        $category->update($data);
       // dd($request->all());
        $this->enviarimagem($request,$id);

        if(isset($request->criar)){
          return redirect()->route('noticias.index');
        }
        return redirect()->route('noticias.edit', [$id]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function delete($account, $id)
    {
        $category = Noticia::find($id);
        $category->delete();
        return redirect()->routeTenant('noticias.index');
    }

    public function deletarimagens($account, $id)
    {
        $category = ImagemNoticia::find($id);
        $category->delete();
        return redirect()->back()->with('success','Deletado com sucesso');
    }

  public function enviarimagem(Request  $request, $id)
  {
    $data = $request->all();
    if($request->url_imagem2)
    {
      $imagem = $request->url_imagem2;
      $extensao = $imagem->getClientOriginalExtension();
      if(
        $extensao != 'jpg'
        && $extensao != 'png'
        && $extensao != 'svg'
        && $extensao != 'jpeg'
        && $extensao != 'JPEG'
        && $extensao != 'JPG'
        && $extensao != 'PNG'
      )
      {
        return back()->with('erro','Erro: Este arquivo não é uma imagem valida (jpg, png, svg, jpeg)');
      }
    }
    else
    {
    }
    $rand = rand(1,100000);
    $time = time();

    if($request->url_imagem2)
    {
      $strCaminho = public_path().'/portais/noticias/';
      if(!file_exists($strCaminho)) { // Cria pasta para o projeto, caso não já exista uma
        $objProjetoDiretorio = File::makeDirectory($strCaminho,0777,true);
      }
      $request->url_imagem2->move($strCaminho,$time.$rand.'.'.$extensao);
      $data['url'] ='/portais/noticias/'.$time.$rand.'.'.$extensao;
      $data['noticia_id'] = $id;
      $data2['noticia_edicao'] = 1;
      $id = Noticia::find($id)->update($data2);
      $category = ImagemNoticia::create($data);
    }
  }
}
