<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/genomics/v1/variants.proto

namespace Google\Genomics\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A call represents the determination of genotype with respect to a particular
 * variant. It may include associated information such as quality and phasing.
 * For example, a call might assign a probability of 0.32 to the occurrence of
 * a SNP named rs1234 in a call set with the name NA12345.
 *
 * Generated from protobuf message <code>google.genomics.v1.VariantCall</code>
 */
class VariantCall extends \Google\Protobuf\Internal\Message
{
    /**
     * The ID of the call set this variant call belongs to.
     *
     * Generated from protobuf field <code>string call_set_id = 8;</code>
     */
    private $call_set_id = '';
    /**
     * The name of the call set this variant call belongs to.
     *
     * Generated from protobuf field <code>string call_set_name = 9;</code>
     */
    private $call_set_name = '';
    /**
     * The genotype of this variant call. Each value represents either the value
     * of the `referenceBases` field or a 1-based index into
     * `alternateBases`. If a variant had a `referenceBases`
     * value of `T` and an `alternateBases`
     * value of `["A", "C"]`, and the `genotype` was
     * `[2, 1]`, that would mean the call
     * represented the heterozygous value `CA` for this variant.
     * If the `genotype` was instead `[0, 1]`, the
     * represented value would be `TA`. Ordering of the
     * genotype values is important if the `phaseset` is present.
     * If a genotype is not called (that is, a `.` is present in the
     * GT string) -1 is returned.
     *
     * Generated from protobuf field <code>repeated int32 genotype = 7;</code>
     */
    private $genotype;
    /**
     * If this field is present, this variant call's genotype ordering implies
     * the phase of the bases and is consistent with any other variant calls in
     * the same reference sequence which have the same phaseset value.
     * When importing data from VCF, if the genotype data was phased but no
     * phase set was specified this field will be set to `*`.
     *
     * Generated from protobuf field <code>string phaseset = 5;</code>
     */
    private $phaseset = '';
    /**
     * The genotype likelihoods for this variant call. Each array entry
     * represents how likely a specific genotype is for this call. The value
     * ordering is defined by the GL tag in the VCF spec.
     * If Phred-scaled genotype likelihood scores (PL) are available and
     * log10(P) genotype likelihood scores (GL) are not, PL scores are converted
     * to GL scores.  If both are available, PL scores are stored in `info`.
     *
     * Generated from protobuf field <code>repeated double genotype_likelihood = 6;</code>
     */
    private $genotype_likelihood;
    /**
     * A map of additional variant call information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 2;</code>
     */
    private $info;

    public function __construct() {
        \GPBMetadata\Google\Genomics\V1\Variants::initOnce();
        parent::__construct();
    }

    /**
     * The ID of the call set this variant call belongs to.
     *
     * Generated from protobuf field <code>string call_set_id = 8;</code>
     * @return string
     */
    public function getCallSetId()
    {
        return $this->call_set_id;
    }

    /**
     * The ID of the call set this variant call belongs to.
     *
     * Generated from protobuf field <code>string call_set_id = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCallSetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->call_set_id = $var;

        return $this;
    }

    /**
     * The name of the call set this variant call belongs to.
     *
     * Generated from protobuf field <code>string call_set_name = 9;</code>
     * @return string
     */
    public function getCallSetName()
    {
        return $this->call_set_name;
    }

    /**
     * The name of the call set this variant call belongs to.
     *
     * Generated from protobuf field <code>string call_set_name = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setCallSetName($var)
    {
        GPBUtil::checkString($var, True);
        $this->call_set_name = $var;

        return $this;
    }

    /**
     * The genotype of this variant call. Each value represents either the value
     * of the `referenceBases` field or a 1-based index into
     * `alternateBases`. If a variant had a `referenceBases`
     * value of `T` and an `alternateBases`
     * value of `["A", "C"]`, and the `genotype` was
     * `[2, 1]`, that would mean the call
     * represented the heterozygous value `CA` for this variant.
     * If the `genotype` was instead `[0, 1]`, the
     * represented value would be `TA`. Ordering of the
     * genotype values is important if the `phaseset` is present.
     * If a genotype is not called (that is, a `.` is present in the
     * GT string) -1 is returned.
     *
     * Generated from protobuf field <code>repeated int32 genotype = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGenotype()
    {
        return $this->genotype;
    }

    /**
     * The genotype of this variant call. Each value represents either the value
     * of the `referenceBases` field or a 1-based index into
     * `alternateBases`. If a variant had a `referenceBases`
     * value of `T` and an `alternateBases`
     * value of `["A", "C"]`, and the `genotype` was
     * `[2, 1]`, that would mean the call
     * represented the heterozygous value `CA` for this variant.
     * If the `genotype` was instead `[0, 1]`, the
     * represented value would be `TA`. Ordering of the
     * genotype values is important if the `phaseset` is present.
     * If a genotype is not called (that is, a `.` is present in the
     * GT string) -1 is returned.
     *
     * Generated from protobuf field <code>repeated int32 genotype = 7;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGenotype($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT32);
        $this->genotype = $arr;

        return $this;
    }

    /**
     * If this field is present, this variant call's genotype ordering implies
     * the phase of the bases and is consistent with any other variant calls in
     * the same reference sequence which have the same phaseset value.
     * When importing data from VCF, if the genotype data was phased but no
     * phase set was specified this field will be set to `*`.
     *
     * Generated from protobuf field <code>string phaseset = 5;</code>
     * @return string
     */
    public function getPhaseset()
    {
        return $this->phaseset;
    }

    /**
     * If this field is present, this variant call's genotype ordering implies
     * the phase of the bases and is consistent with any other variant calls in
     * the same reference sequence which have the same phaseset value.
     * When importing data from VCF, if the genotype data was phased but no
     * phase set was specified this field will be set to `*`.
     *
     * Generated from protobuf field <code>string phaseset = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setPhaseset($var)
    {
        GPBUtil::checkString($var, True);
        $this->phaseset = $var;

        return $this;
    }

    /**
     * The genotype likelihoods for this variant call. Each array entry
     * represents how likely a specific genotype is for this call. The value
     * ordering is defined by the GL tag in the VCF spec.
     * If Phred-scaled genotype likelihood scores (PL) are available and
     * log10(P) genotype likelihood scores (GL) are not, PL scores are converted
     * to GL scores.  If both are available, PL scores are stored in `info`.
     *
     * Generated from protobuf field <code>repeated double genotype_likelihood = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGenotypeLikelihood()
    {
        return $this->genotype_likelihood;
    }

    /**
     * The genotype likelihoods for this variant call. Each array entry
     * represents how likely a specific genotype is for this call. The value
     * ordering is defined by the GL tag in the VCF spec.
     * If Phred-scaled genotype likelihood scores (PL) are available and
     * log10(P) genotype likelihood scores (GL) are not, PL scores are converted
     * to GL scores.  If both are available, PL scores are stored in `info`.
     *
     * Generated from protobuf field <code>repeated double genotype_likelihood = 6;</code>
     * @param float[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGenotypeLikelihood($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::DOUBLE);
        $this->genotype_likelihood = $arr;

        return $this;
    }

    /**
     * A map of additional variant call information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getInfo()
    {
        return $this->info;
    }

    /**
     * A map of additional variant call information. This must be of the form
     * map<string, string[]> (string key mapping to a list of string values).
     *
     * Generated from protobuf field <code>map<string, .google.protobuf.ListValue> info = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setInfo($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Protobuf\ListValue::class);
        $this->info = $arr;

        return $this;
    }

}

