<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ml/v1/job_service.proto

namespace Google\Cloud\Ml\V1;

/**
 * A scale tier is an abstract representation of the resources Cloud ML
 * will allocate to a training job. When selecting a scale tier for your
 * training job, you should consider the size of your training dataset and
 * the complexity of your model. As the tiers increase, virtual machines are
 * added to handle your job, and the individual machines in the cluster
 * generally have more memory and greater processing power than they do at
 * lower tiers. The number of training units charged per hour of processing
 * increases as tiers get more advanced. Refer to the
 * [pricing guide](/ml/pricing) for more details. Note that in addition to
 * incurring costs, your use of training resources is constrained by the
 * [quota policy](/ml/quota).
 *
 * Protobuf enum <code>Google\Cloud\Ml\V1\TrainingInput\ScaleTier</code>
 */
class TrainingInput_ScaleTier
{
    /**
     * A single worker instance. This tier is suitable for learning how to use
     * Cloud ML, and for experimenting with new models using small datasets.
     *
     * Generated from protobuf enum <code>BASIC = 0;</code>
     */
    const BASIC = 0;
    /**
     * Many workers and a few parameter servers.
     *
     * Generated from protobuf enum <code>STANDARD_1 = 1;</code>
     */
    const STANDARD_1 = 1;
    /**
     * A large number of workers with many parameter servers.
     *
     * Generated from protobuf enum <code>PREMIUM_1 = 3;</code>
     */
    const PREMIUM_1 = 3;
    /**
     * A single worker instance [with a GPU](ml/docs/how-tos/using-gpus).
     *
     * Generated from protobuf enum <code>BASIC_GPU = 6;</code>
     */
    const BASIC_GPU = 6;
    /**
     * The CUSTOM tier is not a set tier, but rather enables you to use your
     * own cluster specification. When you use this tier, set values to
     * configure your processing cluster according to these guidelines:
     * *   You _must_ set `TrainingInput.masterType` to specify the type
     *     of machine to use for your master node. This is the only required
     *     setting.
     * *   You _may_ set `TrainingInput.workerCount` to specify the number of
     *     workers to use. If you specify one or more workers, you _must_ also
     *     set `TrainingInput.workerType` to specify the type of machine to use
     *     for your worker nodes.
     * *   You _may_ set `TrainingInput.parameterServerCount` to specify the
     *     number of parameter servers to use. If you specify one or more
     *     parameter servers, you _must_ also set
     *     `TrainingInput.parameterServerType` to specify the type of machine to
     *     use for your parameter servers.
     * Note that all of your workers must use the same machine type, which can
     * be different from your parameter server type and master type. Your
     * parameter servers must likewise use the same machine type, which can be
     * different from your worker type and master type.
     *
     * Generated from protobuf enum <code>CUSTOM = 5;</code>
     */
    const CUSTOM = 5;
}

